import { Dimension, world } from '@minecraft/server';
import { Vec3 } from '../utils/Vec3.js';
export class ChrysalisData {
  static CHRYSALIS_DATA_KEY = 'sf_nba:chrysalisData';
  static getChrysalisDataKey(dimension, location) {
    const x = Math.floor(location.x);
    const y = Math.floor(location.y);
    const z = Math.floor(location.z);
    return `${this.CHRYSALIS_DATA_KEY}_${dimension.id}_${x}_${y}_${z}`;
  }
  static register(chrysalisDataKey, data) {
    world.setDynamicProperty(chrysalisDataKey, data);
  }
  static delete(chrysalisDataKey) {
    world.setDynamicProperty(chrysalisDataKey, null);
  }
  static getAndDelete(dimension, location) {
    const chrysalisDataKey = this.getChrysalisDataKey(dimension, location);
    const data = world.getDynamicProperty(chrysalisDataKey);
    if (data == null) return;
    this.delete(chrysalisDataKey);
    return data;
  }
  static {
    const pistonMoveMap = {
      0: { Expanding: new Vec3(0, -1, 0), Retracting: new Vec3(0, 1, 0) },
      1: { Expanding: new Vec3(0, 1, 0), Retracting: new Vec3(0, -1, 0) },
      2: { Expanding: new Vec3(0, 0, 1), Retracting: new Vec3(0, 0, -1) },
      3: { Expanding: new Vec3(0, 0, -1), Retracting: new Vec3(0, 0, 1) },
      4: { Expanding: new Vec3(1, 0, 0), Retracting: new Vec3(-1, 0, 0) },
      5: { Expanding: new Vec3(-1, 0, 0), Retracting: new Vec3(1, 0, 0) }
    };
    world.afterEvents.pistonActivate.subscribe(({ piston, block, dimension }) => {
      const { state } = piston;
      const direction = block.permutation.getState('facing_direction');
      const movedBlocks = piston.getAttachedBlocks();
      for (let i = movedBlocks.length; i--;) {
        const movedBlock = movedBlocks[i];
        const chrysalisData = this.getAndDelete(dimension, movedBlock.location);
        if (!chrysalisData) continue;
        const newLocation = pistonMoveMap[direction][state];
        this.register(dimension, newLocation, chrysalisData);
      }
    });
  }
}